/*
 * Decompiled with CFR 0.152.
 */
package com.alexscottrhodes.copyright_plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class CopyrightGenerator
extends AbstractMojo {
    private File sourceDir = new File("");
    private final File testDir = new File("");
    private ArrayList<String> fileNames;

    public void execute() throws MojoExecutionException {
        if (!this.sourceDir.exists()) {
            this.getLog().error((CharSequence)"Could not find source directory specified in POM");
        }
        this.populateFileList(this.sourceDir);
        this.populateFileList(this.testDir);
        Iterator<String> it = this.fileNames.iterator();
        while (it.hasNext()) {
            String ext;
            String name = it.next();
            if (name.lastIndexOf(".") == -1) {
                it.remove();
            }
            if ((ext = name.substring(name.lastIndexOf("."))).contains("xhtml") || ext.contains("html") || ext.contains("xml") || ext.contains("java")) continue;
            it.remove();
        }
        for (String fname : this.fileNames) {
            this.writeHeader(fname);
        }
    }

    public void populateFileList(File root) {
        if (root.isFile()) {
            this.fileNames.add(root.getPath());
            return;
        }
        for (File file : root.listFiles()) {
            if (file.isDirectory()) {
                this.populateFileList(file);
                continue;
            }
            this.fileNames.add(file.getPath());
        }
    }

    public void writeHeader(String fileName) {
        try {
            File edit = new File(fileName);
            FileInputStream fis = new FileInputStream(edit);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            String result = "";
            String line = "";
            while ((line = br.readLine()) != null) {
                result = result + line;
            }
            result = "Appended copyright test \n" + result;
            edit.delete();
            FileOutputStream fos = new FileOutputStream(edit);
            fos.write(result.getBytes());
            fos.flush();
            fos.close();
            br.close();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Unable to edit file:" + fileName));
        }
    }
}

