/*
 * Decompiled with CFR 0.152.
 */
package com.alexscottrhodes.copyright_plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

@Mojo(name="cr")
public class CopyrightGenerator
extends AbstractMojo {
    @Parameter(defaultValue="${remove}")
    private boolean remove = false;
    @Parameter(defaultValue="${basedir}", required=true)
    private File sourceDir = new File("");
    private ArrayList<String> fileNames = new ArrayList();
    private HashMap<String, String> copyrightText = new HashMap();

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("remove = " + this.remove));
        if (!this.sourceDir.exists()) {
            this.getLog().error((CharSequence)"Could not find source directory specified in POM");
        }
        this.populateFileList(this.sourceDir);
        Iterator<String> it = this.fileNames.iterator();
        while (it.hasNext()) {
            String ext;
            String name = it.next();
            if (name.contains("copyright-config.xml")) {
                this.populateCopyrights(name);
                if (this.copyrightText.size() < 1) {
                    this.getLog().error((CharSequence)"Copyright confiruation invalid.");
                    return;
                }
            }
            if (name.lastIndexOf(".") == -1) {
                it.remove();
            }
            if ((ext = name.substring(name.lastIndexOf("."))).contains("xhtml") || ext.contains("html") || ext.contains("xml") || ext.contains("java")) continue;
            it.remove();
        }
        for (String fname : this.fileNames) {
            if (this.remove) {
                this.stripHeader(fname);
                continue;
            }
            this.writeHeader(fname);
        }
    }

    public void populateFileList(File root) {
        if (root.isFile()) {
            this.fileNames.add(root.getPath());
            return;
        }
        for (File file : root.listFiles()) {
            if (file.isDirectory()) {
                this.populateFileList(file);
                continue;
            }
            this.fileNames.add(file.getPath());
        }
    }

    public void writeHeader(String fileName) {
        String header = this.getBody(fileName);
        if (header == null) {
            return;
        }
        try {
            String testHeader;
            String line;
            if (fileName.contains("copyright-plugin-backup") || fileName.contains("copyright-config.xml")) {
                return;
            }
            File edit = new File(fileName);
            File backupDest = new File(this.sourceDir.getAbsolutePath() + "/copyright-plugin-backup/");
            backupDest.mkdirs();
            FileUtils.copyFileToDirectory((File)edit, (File)backupDest);
            FileInputStream fis = new FileInputStream(edit);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            String testSequence = "";
            while ((line = br.readLine()) != null) {
                testSequence = testSequence + line;
            }
            if ((testSequence = this.sanitize(testSequence)).contains(testHeader = this.sanitize(new String(header)))) {
                br.close();
                fis.close();
                return;
            }
            br.close();
            fis.close();
            fis = new FileInputStream(edit);
            br = new BufferedReader(new InputStreamReader(fis));
            PrintWriter writer = new PrintWriter("tmp");
            writer.println(header);
            while ((line = br.readLine()) != null) {
                writer.println(line);
            }
            writer.close();
            br.close();
            fis.close();
            edit.delete();
            File temp = new File("tmp");
            Path source = Paths.get(temp.getAbsolutePath(), new String[0]);
            Files.move(source, source.resolveSibling(fileName), new CopyOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stripHeader(String fileName) {
        String header = this.getBody(fileName);
        if (header == null) {
            return;
        }
        try {
            String line;
            if (fileName.contains("copyright-plugin-backup") || fileName.contains("copyright-config.xml")) {
                return;
            }
            File edit = new File(fileName);
            File backupDest = new File(this.sourceDir.getAbsolutePath() + "/copyright-plugin-backup/");
            backupDest.mkdirs();
            FileUtils.copyFileToDirectory((File)edit, (File)backupDest);
            FileInputStream fis = new FileInputStream(edit);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            PrintWriter writer = new PrintWriter("tmp");
            while ((line = br.readLine()) != null) {
                if (header.contains(line)) continue;
                writer.println(line);
            }
            writer.close();
            br.close();
            fis.close();
            edit.delete();
            File temp = new File("tmp");
            Path source = Paths.get(temp.getAbsolutePath(), new String[0]);
            Files.move(source, source.resolveSibling(fileName), new CopyOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getBody(String fileName) {
        if (fileName.lastIndexOf(".") == -1) {
            return null;
        }
        String ext = fileName.substring(fileName.lastIndexOf("."));
        String body = this.copyrightText.get(ext = ext.replace(".", ""));
        if (body == null) {
            return body;
        }
        if (ext.equalsIgnoreCase("java")) {
            body = "/*" + body + "*/";
        } else if (ext.equalsIgnoreCase("xml") || ext.equalsIgnoreCase("xhtml") || ext.equalsIgnoreCase("html")) {
            body = "<!-- \n" + body + "\n -->";
        }
        return body;
    }

    public void populateCopyrights(String configFileName) {
        try {
            SAXBuilder builder = new SAXBuilder();
            File config = new File(configFileName);
            Document document = builder.build(config);
            Element root = document.getRootElement();
            List copyrightElements = root.getChildren("copyright");
            for (int i = 0; i < copyrightElements.size(); ++i) {
                Element cp = (Element)copyrightElements.get(i);
                String ext = cp.getChildText("file-type");
                if (ext == null) {
                    throw new Exception("Invalid copyright configuration file.");
                }
                if (!(ext.equals("xhtml") || ext.equals("html") || ext.equals("xml") || ext.equals("java"))) {
                    throw new Exception("Unsupproted file type in copyright configuration file.");
                }
                String body = cp.getChildText("body");
                if (body == null || body == "") continue;
                this.copyrightText.put(ext, body);
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)e.getMessage());
        }
    }

    public String sanitize(String in) {
        in = in.replace("\n", "").replace("\r", "").replace(" ", "").replaceAll("\t", "");
        return in;
    }
}

