/*
Google Charts JSF Wrapper
Copyright (C) 2016  Alex Rhodes
https://www.alexscottrhodes.com

Information about this project including set-up and configuration information can be found here:
https://bitbucket.org/alexscottrhodes/googlechartjsf

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0
	
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

 2016 "Google" and the Google logo are registered trademarks of Google Inc.
The Google Charts API is used under the Apache 2.0 License above. Google software 
is loaded from Google's servers as required in the Google Terms of Service.
*/
package com.alexscottrhodes.constructionModel;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import com.alexscottrhodes.enums.SeriesDisplayType;
import com.alexscottrhodes.enums.SeriesType;

/**
 * An object representing a data series and related parameters to pass into a chart
 * @author Alex Rhodes
 *
 */
@SuppressWarnings("unchecked")
public class ChartSeries {
	private String label = "";
	private SeriesType type = SeriesType.STRING;
	private SeriesDisplayType displayType = SeriesDisplayType.BAR;
	private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy hh:mm:ss");

	/**
	 * Constructor that requires definition of the data type being put into the chart series
	 * @param type a SeriesType representative of the data type of the series 
	 */
	public ChartSeries(SeriesType type){
		this.type = type;
	}
	
	@SuppressWarnings("rawtypes")
	private ArrayList dataset = new ArrayList();

	public String getLabel() {
		return label;
	}
	public void setLabel(String label) {
		this.label = label;
	}
	@SuppressWarnings("rawtypes")
	public ArrayList getDataset() {
		return dataset;
	}


	public void addPoint(Integer point){
		dataset.add(point);
	}
	
	public void addPoint(String point){
		dataset.add(point);
	}
	
	public void addPoint(Date point){
		try{
			point = simpleDateFormat.parse(simpleDateFormat.format(point));
			dataset.add(point);
		}catch(Exception e){
			try {
				throw new Exception("Unable to parse date: " + point);
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
	}
	
	public void addPoint(Float point){
		dataset.add(point);
	}
	
	public SeriesType getType(){
		return type;
	}
	public SimpleDateFormat getDateFormat() {
		return simpleDateFormat;
	}
	public void setDateFormat(String format) {
		simpleDateFormat = new SimpleDateFormat(format);
	}
	public SeriesDisplayType getDisplayType() {
		return displayType;
	}
	public void setDisplayType(SeriesDisplayType displayType) {
		this.displayType = displayType;
	}
}
