package com.alexscottrhodes.groups;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

@FacesComponent(tagName = "groupable", createTag = true, namespace = "http://alexscottrhodes.com/facelets/pfe", value = "com.alexscottrhodes.groupable")
public class Groupable extends UIComponentBase {

	@Override
	public String getFamily() {
		return "com.alexscottrhodes.groupable";
	}
	@Override
	public void encodeEnd(FacesContext context) throws IOException {
		//ResponseWriter writer = context.getResponseWriter();
		@SuppressWarnings("rawtypes")
		ArrayList value;
		try{
			value = (ArrayList<?>) this.getAttributes().get("value");
		}catch(Exception e){
			throw new RuntimeException("Invalid data.");
		}
			
	  	String var = (String) this.getAttributes().get("var");
	    Map<String, Object> requestMap = context.getExternalContext().getRequestMap();
	    Object o = requestMap.get(var); 

		for(Object obj : value){
			obj.getClass();
			requestMap.put(var, obj);
			for(UIComponent child : this.getChildren()){
				child.encodeAll(this.getFacesContext());
			}
		}
	    if(o != null){
	            requestMap.put(var, o);
	        }else{
	            requestMap.remove(var);
	        }
	}
	
}
