/*
Google Charts JSF Wrapper
Copyright (C) 2016  Alex Rhodes
https://www.alexscottrhodes.com

Information about this project including set-up and configuration information can be found here:
https://bitbucket.org/alexscottrhodes/googlechartjsf

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0
	
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

 2016 "Google" and the Google logo are registered trademarks of Google Inc.
The Google Charts API is used under the Apache 2.0 License above. Google software 
is loaded from Google's servers as required in the Google Terms of Service.
*/
package com.alexscottrhodes.handler;

import java.io.IOException;

import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

import com.alexscottrhodes.builder.Builder;
import com.alexscottrhodes.chartModel.GoogleComboChart;
import com.alexscottrhodes.chartModel.GooglePieChart;
import com.alexscottrhodes.exceptions.ChartException;

/**
 * Tag handler for the google charts API wrapper.
 * 
 * @author Alex Rhodes
 * 
 */
@FacesComponent(tagName = "googleChart", createTag = true, namespace = "http://alexscottrhodes.com/facelets", value = "com.alexscottrhodes.googleChart")
public class GoogleChartTagHandler extends UIComponentBase {
	@Override
	public String getFamily() {
		return "com.alexscottrhodes.googleChart";
	}

	@Override
	public void encodeEnd(FacesContext context) throws IOException {
		GoogleComboChart gcc = null;
		GooglePieChart gpc = null;
		ResponseWriter writer = context.getResponseWriter();
		String output = null;
		String id = "";
		try {
			id = (String) this.getAttributes().get("id");
		} catch (Exception e) {
			throw new ChartException("No ID Specified");
		}
		// Collect parameters
		String typeString = (String) getAttributes().get("type");
		Object chartObject = getAttributes().get("value");

		if (typeString == null) {
			throw new ChartException("Invalid or missing chart type.");
		}

		// Cast to appropriate chart model
		if (typeString.equals("combo")) {

			try {
				gcc = (GoogleComboChart) chartObject;
				gcc.setId(id);
			} catch (Exception e) {
				throw new ChartException("Invalid chart model.");
			}
			Builder b = new Builder();
			try {
				output = b.buildComboChart(gcc);
			} catch (Exception e) {
				throw new ChartException("Error rendering.");
			}

		}
		else if (typeString.equals("pie")) {
			try {
				gpc = (GooglePieChart) chartObject;
				gpc.setId(id);
			} catch (Exception e) {
				throw new ChartException("Invalid chart model.");
			}
			Builder b = new Builder();
			output = b.buildPieChart(gpc);

		}

		else {
			throw new ChartException("Invalid chart type:" + typeString);
		}
		writer.write(output);
	}

}
