/*
Google Charts JSF Wrapper
Copyright (C) 2016  Alex Rhodes
https://www.alexscottrhodes.com

Information about this project including set-up and configuration information can be found here:
https://bitbucket.org/alexscottrhodes/googlechartjsf

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0
	
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

 2016 "Google" and the Google logo are registered trademarks of Google Inc.
The Google Charts API is used under the Apache 2.0 License above. Google software 
is loaded from Google's servers as required in the Google Terms of Service.
*/
package com.alexscottrhodes.demo;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;

import com.alexscottrhodes.chartModel.GoogleComboChart;
import com.alexscottrhodes.chartModel.GooglePieChart;
import com.alexscottrhodes.chartModel.components.PieSlice;
import com.alexscottrhodes.constructionModel.ChartSeries;
import com.alexscottrhodes.enums.AxisType;
import com.alexscottrhodes.enums.CurveType;
import com.alexscottrhodes.enums.SeriesDisplayType;
import com.alexscottrhodes.enums.SeriesType;
/**
 * Demonstration of the Google Chart object construction 
 * @author Alex Rhodes
 *
 */
public class Charts {
	/**
	 * Build a Combo chart
	 * @return a GoogleComboChart 
	 */
	public static GoogleComboChart getComboChart() {
		GoogleComboChart gcc;
		gcc = new GoogleComboChart();
		gcc.setTitle("This is the Title");
		gcc.setTitleBold(true); // Bolded title
		gcc.setTitleColor("#59b300"); // Green title
		gcc.setCurveType(CurveType.FUNCTION); // Smoothed curve
		gcc.setHeight(800);
		gcc.setWidth(1200);
		gcc.setVerticalAxisLabel("Y-Axis vals"); // Label for Y-axis
		gcc.setIndexLine(50, "Target Amount"); // add an index line

		ChartSeries s = new ChartSeries(SeriesType.NUMBER); // Add a series of
															// numbers
		s.setDisplayType(SeriesDisplayType.LINE); // Make this series a line
		s.setLabel("A line of values over time.");
		for (Integer i : getRandVals()) {
			s.addPoint(i); // Populate with some random numbers
		}

		ChartSeries t = new ChartSeries(SeriesType.NUMBER); // Add a series of
															// numbers
		t.setDisplayType(SeriesDisplayType.BAR); // Make this series bars
		t.setLabel("A second set of values over time");
		for (Integer i : getRandVals()) {
			t.addPoint(i); // Populate with some random numbers
		}

		ChartSeries x = new ChartSeries(SeriesType.DATE); // Add a series of
															// Dates
		x.setDateFormat("yyyy-MM-dd"); // Format the date output
		x.setLabel("Date - X-axis vals");
		for (Date d : getDates()) {
			x.addPoint(d); // Populate with some dates
		}

		gcc.addSeries(s); // Add series S
		gcc.addSeries(t);// Add series T
		gcc.addAxisSeries(x, AxisType.X); // Add the X-axis
		return gcc;
	}
	
	/**
	 * Build a Google Pie Chart
	 * @return a Google Pie Chart object
	 */
	public static GooglePieChart getPieChart(){
		GooglePieChart gpc = new GooglePieChart("Activity","Time Spent");
		gpc.setDataName("Activity");
		gpc.setDataType("Time spent");
		gpc.setHeight(900);
		gpc.setWidth(700);
		gpc.setIs3d(true);
		gpc.setRotation(45);
		gpc.setTitle("Debugging Code");
		gpc.setTitleBold(true);
		gpc.setTitleColor("#ff6600");
		
		PieSlice p = new PieSlice("Googling",20);
		p.setOffset(0.4);
		PieSlice q = new PieSlice("Stack Exchange",30);
		q.setOffset(0.2);
		PieSlice r = new PieSlice("Stepping Through",40);
		PieSlice s = new PieSlice("Crying", 10);
		
		gpc.addSlice(p);
		gpc.addSlice(q);
		gpc.addSlice(r);
		gpc.addSlice(s);
		
		return gpc;
	}
	

	// Utility to get some random numbers
	public static ArrayList<Integer> getRandVals() {
		Random r = new Random();
		ArrayList<Integer> result = new ArrayList<Integer>();
		for (int i = 0; i < 10; i++) {
			result.add(r.nextInt(100 - 10) + 10);
		}
		return result;
	}

	// Utility to get some dates
	public static ArrayList<Date> getDates() {
		ArrayList<Date> result = new ArrayList<Date>();
		Calendar c = Calendar.getInstance();
		c.setTime(new Date());
		for (int i = 0; i < 10; i++) {
			c.add(Calendar.DATE, 7);
			result.add(c.getTime());
		}
		return result;
	}

}
