package com.alexscottrhodes.constructionModel;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import com.alexscottrhodes.enums.SeriesDisplayType;
import com.alexscottrhodes.enums.SeriesType;

/**
 * An object representing a data series and related parameters to pass into a chart
 * @author Alex Rhodes
 *
 */
@SuppressWarnings("unchecked")
public class ChartSeries {
	private String label = "";
	private SeriesType type = SeriesType.STRING;
	private SeriesDisplayType displayType = SeriesDisplayType.BAR;
	private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy hh:mm:ss");

	/**
	 * Constructor that requires definition of the data type being put into the chart series
	 * @param type a SeriesType representative of the data type of the series 
	 */
	public ChartSeries(SeriesType type){
		this.type = type;
	}
	
	@SuppressWarnings("rawtypes")
	private ArrayList dataset = new ArrayList();

	public String getLabel() {
		return label;
	}
	public void setLabel(String label) {
		this.label = label;
	}
	@SuppressWarnings("rawtypes")
	public ArrayList getDataset() {
		return dataset;
	}


	public void addPoint(Integer point){
		dataset.add(point);
	}
	
	public void addPoint(String point){
		dataset.add(point);
	}
	
	public void addPoint(Date point){
		try{
			point = simpleDateFormat.parse(simpleDateFormat.format(point));
			dataset.add(point);
		}catch(Exception e){
			try {
				throw new Exception("Unable to parse date: " + point);
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
	}
	
	public void addPoint(Float point){
		dataset.add(point);
	}
	
	public SeriesType getType(){
		return type;
	}
	public SimpleDateFormat getDateFormat() {
		return simpleDateFormat;
	}
	public void setDateFormat(String format) {
		simpleDateFormat = new SimpleDateFormat(format);
	}
	public SeriesDisplayType getDisplayType() {
		return displayType;
	}
	public void setDisplayType(SeriesDisplayType displayType) {
		this.displayType = displayType;
	}
}
