/*
Google Charts JSF Wrapper
Copyright (C) 2016  Alex Rhodes
https://www.alexscottrhodes.com

Information about this project including set-up and configuration information can be found here:
https://bitbucket.org/alexscottrhodes/googlechartjsf

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0
	
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

 2016 "Google" and the Google logo are registered trademarks of Google Inc.
The Google Charts API is used under the Apache 2.0 License above. Google software 
is loaded from Google's servers as required in the Google Terms of Service.
*/
package com.alexscottrhodes.chartModel.components;

/**
 * Model of a Google Pie Slice object
 * @author Alex Rhodes
 *
 */
public class PieSlice {
	private double value;
	private String name;
	private boolean visible = true;
	private String color;
	private double offset;
	
	public PieSlice(String name, double value){
		this.name = name;
		this.value = value;
	}
	public PieSlice(String name, int value){
		this.name = name;
		this.value = value;
	}
	public boolean isVisible() {
		return visible;
	}
	public void setVisible(boolean visible) {
		this.visible = visible;
	}
	public String getColor() {
		return color;
	}
	public void setColor(String color) {
		this.color = color;
	}
	public void setOffset(double offset) {
		this.offset = offset;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public double getValue() {
		return value;
	}

	public void setValue(double value) {
		this.value = value;
	}

	public double getOffset() {
		return offset;
	}
	
}
