package com.alexscottrhodes.chartModel;

/**
 * Model representing a google chart
 */
import java.util.ArrayList;
import java.util.HashMap;

import com.alexscottrhodes.constructionModel.ChartSeries;
import com.alexscottrhodes.enums.AxisType;
import com.alexscottrhodes.enums.CurveType;

public class GoogleComboChart {
	private String id;
	private String title;
	private int width;
	private int height;
	private int indexLineVal;
	private String indexLineLabel;
	private ArrayList<ChartSeries> seriesList;
	private HashMap<AxisType, ArrayList<ChartSeries>> axes;
	private String titleColor;
	private boolean titleBold;
	private String verticalAxisLabel;
	private CurveType curveType = CurveType.DEFAULT;
	
	public GoogleComboChart(){
		seriesList = new ArrayList<ChartSeries>();
		axes = new HashMap<AxisType, ArrayList<ChartSeries>>();
		axes.put(AxisType.X, new ArrayList<ChartSeries>());
		axes.put(AxisType.Y, new ArrayList<ChartSeries>());
	}
	/**
	 * Create an index line to be displayed across the chart
	 * @param value an Int of the Y value to draw the index line
	 * @param label a String to display as the label for the index line
	 */
	public void setIndexLine(int value, String label) {
		this.indexLineVal = value;
		this.indexLineLabel = label;
	}
	
	/**
	 * Add a data series to the chart
	 * @param series a ChartSeries to be added to the chart
	 */
	public void addSeries(ChartSeries series){
		seriesList.add(series);
	}
	/**
	 * Add a data series to be used as an axis
	 * @param series a ChartSeries object to be added as an axis
	 * @param axis an AxisType specifying which axis to use the series on
	 */
	public void addAxisSeries(ChartSeries series, AxisType axis){
		axes.get(axis).add(series);
	}
	
	/**
	 * Getters and Setters 
	 */
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public String getTitle() {
		return title;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	public int getWidth() {
		return width;
	}
	public void setWidth(int width) {
		this.width = width;
	}
	public int getHeight() {
		return height;
	}
	public void setHeight(int height) {
		this.height = height;
	}
	public ArrayList<ChartSeries> getSeriesList() {
		return seriesList;
	}
	public void setSeriesList(ArrayList<ChartSeries> seriesList) {
		this.seriesList = seriesList;
	}

	public HashMap<AxisType, ArrayList<ChartSeries>> getAxes() {
		return axes;
	}

	public void setAxes(HashMap<AxisType, ArrayList<ChartSeries>> axes) {
		this.axes = axes;
	}

	public boolean isTitleBold() {
		return titleBold;
	}

	public void setTitleBold(boolean titleBold) {
		this.titleBold = titleBold;
	}

	public String getTitleColor() {
		return titleColor;
	}

	public void setTitleColor(String titleColor) {
		this.titleColor = titleColor;
	}

	public String getVerticalAxisLabel() {
		return verticalAxisLabel;
	}

	public void setVerticalAxisLabel(String verticalAxisLabel) {
		this.verticalAxisLabel = verticalAxisLabel;
	}
	
	public String getIndexLineLabel() {
		return indexLineLabel;
	}

	public int getIndexLineVal() {
		return indexLineVal;
	}
	public CurveType getCurveType() {
		return curveType;
	}
	public void setCurveType(CurveType curveType) {
		this.curveType = curveType;
	}

}
