package com.alexscottrhodes.demo;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;

import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;

import com.alexscottrhodes.chartModel.GoogleChartCore;
import com.alexscottrhodes.constructionModel.ChartSeries;
import com.alexscottrhodes.enums.AxisType;
import com.alexscottrhodes.enums.CurveType;
import com.alexscottrhodes.enums.SeriesDisplayType;
import com.alexscottrhodes.enums.SeriesType;

@ManagedBean
@ViewScoped
public class GoogleChartBean {
	
	private GoogleChartCore gcc;
	
	@PostConstruct
	public void init(){
		gcc = new GoogleChartCore();
		gcc.setTitle("This is the Title");
		gcc.setTitleBold(true); //Bolded title
		gcc.setTitleColor("#59b300"); //Green title
		gcc.setCurveType(CurveType.FUNCTION); //Smoothed curve
		gcc.setHeight(800);
		gcc.setWidth(1200);
		gcc.setVerticalAxisLabel("Y-Axis vals"); //Label for Y-axis
		gcc.setIndexLine(50, "Target Amount"); // add an index line
		
		ChartSeries s = new ChartSeries(SeriesType.NUMBER); //Add a series of numbers
		s.setDisplayType(SeriesDisplayType.LINE); //Make this series a line
		s.setLabel("A line of values over time."); 
		for(Integer i : getRandVals()){
			s.addPoint(i); //Populate with some random numbers
		}
		
		ChartSeries t = new ChartSeries(SeriesType.NUMBER); //Add a series of numbers
		t.setDisplayType(SeriesDisplayType.BAR); //Make this series bars
		t.setLabel("A second set of values over time"); 
		for(Integer i : getRandVals()){
			t.addPoint(i); //Populate with some random numbers
		}
		
		ChartSeries x = new ChartSeries(SeriesType.DATE); //Add a series of Dates
		x.setDateFormat("yyyy-MM-dd"); //Format the date output
		x.setLabel("Date - X-axis vals");
		for(Date d : getDates()){
			x.addPoint(d); //Populate with some dates
		}
		
		gcc.addSeries(s); //Add series S
		gcc.addSeries(t);//Add series T
		gcc.addAxisSeries(x,AxisType.X); //Add the X-axis
	}
	
	//Return the chart to render
	public GoogleChartCore getChart(){
		return gcc;
	}
	
	
	
	
	//Utility to get some random numbers
	public ArrayList<Integer> getRandVals(){
		Random r = new Random();
		ArrayList<Integer> result = new ArrayList<Integer>();
		for(int i = 0; i < 10; i++){
			result.add(r.nextInt(100-10) + 10);
		}
		return result;
	}
	
	//Utility to get some dates
	public ArrayList<Date> getDates(){
			ArrayList<Date> result = new ArrayList<Date>();
			Calendar c = Calendar.getInstance();
			c.setTime(new Date());
			for(int i = 0; i < 10; i++){
				c.add(Calendar.DATE, 7);
				result.add(c.getTime());
			}
			return result;
		}
		
}
	
