/**
 * 
 */
package com.alexscottrhodes.builder;

import java.util.ArrayList;
import java.util.Date;

import com.alexscottrhodes.chartModel.GoogleChartCore;
import com.alexscottrhodes.constructionModel.ChartSeries;
import com.alexscottrhodes.enums.AxisType;
import com.alexscottrhodes.enums.SeriesType;
import com.alexscottrhodes.exceptions.AxesException;
import com.alexscottrhodes.exceptions.ChartException;

/**
 * This class contains methods to render the chart object JS
 * @author Alex Rhodes
 *
 */
public class Builder {
	
	/**
	 * Build the chart object and return the string to be rendered in the page
	 * @param gcc a GoogleChartCore object representing the chart
	 * @return a String to render 
	 */
	public String buildComboChart(GoogleChartCore gcc){
	//Verify at least one Axis is provided
	if(gcc.getAxes().get(AxisType.X).size()==0){
		throw new AxesException("No x axis provided.");
	}
	//Verify at least one data series provided
	if(gcc.getSeriesList().size()<1){
		throw new ChartException("No data provided.");
	}
	ArrayList<ChartSeries> data = new ArrayList<ChartSeries>();
	data.addAll(gcc.getAxes().get(AxisType.X));
	data.addAll(gcc.getSeriesList());
	
	//Check for/generate an index line
	if(gcc.getIndexLineVal() != 0){
		ChartSeries index = new ChartSeries(SeriesType.NUMBER);
		int iter = gcc.getAxes().get(AxisType.X).get(0).getDataset().size();
		for(int i = 0; i < iter; i++){
			index.addPoint(gcc.getIndexLineVal());
		}
		index.setLabel(gcc.getIndexLineLabel());
		data.add(index);
		
	}
	//Script header dynamically checks for and loads required Google API JS files while avoiding duplicate call exceptions
	int size = 0;
	String header = ""+
			"<script>"+ 
			"function loader(){"+ 
			"var s = document.createElement(\"script\");"+ 
			"s.src = \"https://www.gstatic.com/charts/loader.js\";"+ 
			"if (s.addEventListener){"+ 
			"window.gChartLoaded = true;"+ 
			"s.addEventListener(\"load\", initGlobal, false);"+ 
			"}else if (s.readyState){"+ 
			"window.gChartLoaded = true;"+ 
			"s.onreadystatechange = initGlobal;"+ 
			"}"+ 
			"document.getElementsByTagName('head')[0].appendChild(s);"+ 
			"}"+ 
			"if(typeof gChartLoaded == \"undefined\"){"+ 
			"window.gChartLoaded = false;"+ 
			"}"+ 
			"if(typeof google == \"undefined\" && !window.gChartLoaded){"+ 
			"loader();"+ 
			"}"+ 
			"function initGlobal(){"+ 
			"window.gChartPackageLoaded = true;"+ 
			"google.charts.load('current', {'packages':['corechart']});"+ 
			"}"+ 
			"</script>"+ 
			"<script>"+ 
			"var asyncLoopA = function(o){"+ 
			"var loop = function(){"+ 
			"if(typeof google != \"undefined\"){o.callback(); return;}"+ 
			"o.asyncLoopFunc(loop);"+ 
			"}\n"+ 
			"loop();"+ 
			"}\n"+ 
			"asyncLoopA({"+ 
			"asyncLoopFunc : function(loop){"+ 
			"	setTimeout(function(){loop();},0);"+ 
			"},"+ 
			"callback : function(){"+ 
			"	google.charts.setOnLoadCallback(function(){"; 
			
		//Data section of the chart
			String dataRows="var data = google.visualization.arrayToDataTable([";
			String colNames = "[";
			for(ChartSeries s : data){
				colNames += "'"+s.getLabel() + "',";
				if(s.getDataset().size()>size){
					size = s.getDataset().size();
				}
			}
			colNames = colNames.substring(0, colNames.lastIndexOf(',')) + "],";
			dataRows += colNames;
			for(int i = 0 ; i < size; i++){
				String row = "[";
				for(ChartSeries s : data){
					if(i< s.getDataset().size()){
						if(s.getType()==SeriesType.NUMBER){
							row+= s.getDataset().get(i);
						}else if(s.getType()==SeriesType.DATE){
							row+= "'" + s.getDateFormat().format((Date)s.getDataset().get(i)) + "'";
						}else{
							row+= "'" + s.getDataset().get(i) + "'";
						}
					}else{
						row+="null";
					}
					row += ",";
				}
				row = row.substring(0, row.lastIndexOf(','));
				row += "],";
				dataRows += row;
			}
			dataRows = dataRows.substring(0,dataRows.lastIndexOf(','));
			dataRows += "]);";
			
			//Options seciton of the chart
			String options = "var options = {";
			if(gcc.getTitle() != null && gcc.getTitle() != ""){
				options += "title: '" + gcc.getTitle() + "',";
			}
			options += "titleTextStyle:{";
			if(gcc.getTitleColor() != null){
				options+= "color: '"+gcc.getTitleColor()+"',";
				options+= "bold:" + gcc.isTitleBold();
			}
			options+="},";
			ChartSeries x = gcc.getAxes().get(AxisType.X).get(0);
			ArrayList<ChartSeries> yList = gcc.getAxes().get(AxisType.Y);
			String yLabel = "";
			if(yList != null && yList.size() > 0 && yList.get(0) != null){
				yLabel = yList.get(0).getLabel();
			}
			if(yLabel == null || yLabel.equals("")){
				yLabel = gcc.getVerticalAxisLabel();
			}
			if(yLabel == null){
				yLabel = "";
			}
			options += "hAxis: {title:'"+x.getLabel()+"'},";
			options += "vAxis: {title:'"+yLabel+"'},";
			options += "curveType: '" + gcc.getCurveType().toString() + "',";
			options += "seriesType: '" + x.getDisplayType().toString() + "',";
			String innerSeries ="series:{";
			for(int i = 0; i <  gcc.getSeriesList().size(); i++){
				ChartSeries s = gcc.getSeriesList().get(i);
				innerSeries += i+": {type:'" + s.getDisplayType().toString()+"'},";
			}
			if(gcc.getIndexLineVal() != 0){
				innerSeries += gcc.getSeriesList().size() + ": {type:'line',lineDashStyle: [5,8],color:'red' },";
			}
			innerSeries = innerSeries.substring(0,innerSeries.lastIndexOf(','));
			innerSeries +="}";
			options += innerSeries + "};";
			//Footer contains dynamically ID'd div to render the chart in
			int height = gcc.getHeight();
			int width = gcc.getWidth();
			if(height == 0){
				height = 500;
			}
			if(width == 0){
				width = 1100;
			}
			String footer = "" +
			"var chart = new  google.visualization.ComboChart(document.getElementById('j_id_comboChartTarget'));"+ 
			"chart.draw(data,options);"+ 
			"});"+ 
			"}    "+ 
		"});	"+ 
	"</script>"+ 
	"<div style='width:"+width+"px;height:"+height+"px;clear:both' id='j_id_comboChartTarget'></div>";
	String result = header + dataRows + options + footer;
	return result;
	}
	
	
	
	
	
	
	
	
	
	
}
