/*
Google Charts JSF Wrapper
Copyright (C) 2016  Alex Rhodes
https://www.alexscottrhodes.com

Information about this project including set-up and configuration information can be found here:
https://bitbucket.org/alexscottrhodes/googlechartjsf

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0
	
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

 2016 "Google" and the Google logo are registered trademarks of Google Inc.
The Google Charts API is used under the Apache 2.0 License above. Google software 
is loaded from Google's servers as required in the Google Terms of Service.
*/
package com.alexscottrhodes.chartModel;

import java.util.ArrayList;

import com.alexscottrhodes.chartModel.components.PieSlice;
/**
 * Model of the Google Pie Chart object
 * @author Alex Rhodes
 *
 */
public class GooglePieChart {
	/**
	 * an ID that will be provided by the JSF build cycle
	 */
	String id;
	/**
	 * The title of the chart.
	 */
	private String title;
	/**
	 * The data type of the chart
	 * See <a href="https://developers.google.com/chart/glossary">Google Charts API</a>
	 */
	private String dataType;
	/**
	 * The unit description of the data
	 * See <a href="https://developers.google.com/chart/glossary">Google Charts API</a>
	 */
	private String dataName;
	/**
	 * A color value to use for the chart's title. The value is a string that can represent any valid HTML or CSS color
	 */
	private String titleColor;
	/**
	 * A boolean to represent a bolded title
	 */
	private boolean titleBold;
	/**
	 * A list of pie slices. Individual slices should be added using the
	 * {@link #addSlice(PieSlice) addSlice} method. 
	 */
	private ArrayList<PieSlice> slices = new ArrayList<PieSlice>();
	/**
	 * The width of the chart in pixels, provided in-line in the  JSF tag with the "width" parameter, excluding "px". The width can also be provided
	 * in the backing bean, and will supersede the in-line width.
	 */
	private int width;
	/**
	 * The height of the chart in pixels, provided in-line in the  JSF tag with the "height" parameter, excluding "px". The height can also be provided
	 * in the backing bean, and will supersede the in-line height.
	 */
	private int height;
	/** 
	 * A boolean to represent a 3-Dimensional chart
	 */
	private boolean is3d;
	/**
	 * A boolean to represent shown or hidden pie slice labels
	 */
	private boolean showSliceText = true;
	/**
	 * The size of a donut hole in a donut hole chart as specified in the Charts API
	 * See <a href="https://developers.google.com/chart/glossary">Google Charts API</a>
	 */
	private double donutHoleSize;
	/**
	 * Degrees of rotation to rotate the pie chart.
	 * See <a href="https://developers.google.com/chart/glossary">Google Charts API</a>
	 */
	private int rotation;
	
	public GooglePieChart(String dataName, String dataType){
		this.dataName = dataName;
		this.dataType  = dataType;
	}
	
	public void addSlice(PieSlice slice){
		slices.add(slice);
	}
	public String getTitle() {
		return title;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	public String getTitleColor() {
		return titleColor;
	}
	public void setTitleColor(String titleColor) {
		this.titleColor = titleColor;
	}
	public boolean isTitleBold() {
		return titleBold;
	}
	public void setTitleBold(boolean titleBold) {
		this.titleBold = titleBold;
	}
	public ArrayList<PieSlice> getSlices() {
		return slices;
	}
	public void setSlices(ArrayList<PieSlice> slices) {
		this.slices = slices;
	}
	public int getWidth() {
		return width;
	}
	public void setWidth(int width) {
		this.width = width;
	}
	public int getHeight() {
		return height;
	}
	public void setHeight(int height) {
		this.height = height;
	}
	public boolean isIs3d() {
		return is3d;
	}
	public void setIs3d(boolean is3d) {
		this.is3d = is3d;
	}
	public void setDonutHoleSize(double d) {
		this.donutHoleSize = d;
	}
	public int getRotation() {
		return rotation;
	}
	public void setRotation(int rotation) {
		this.rotation = rotation;
	}
	public String getDataType() {
		return dataType;
	}
	public void setDataType(String dataType) {
		this.dataType = dataType;
	}
	public String getDataName() {
		return dataName;
	}
	public void setDataName(String dataName) {
		this.dataName = dataName;
	}
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}

	public double getDonutHoleSize() {
		return donutHoleSize;
	}

	public boolean isShowSliceText() {
		return showSliceText;
	}

	public void setShowSliceText(boolean showSliceText) {
		this.showSliceText = showSliceText;
	}
	
	
	
}
