/**
 * 
 */
package com.alexscottrhodes.handler;

import java.io.IOException;

import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

import com.alexscottrhodes.builder.Builder;
import com.alexscottrhodes.chartModel.GoogleChartCore;
import com.alexscottrhodes.exceptions.ChartException;

/**
 * Tag handler for the google charts API wrapper. 
 * 
 * @author Alex Rhodes
 * 
 */
@FacesComponent(tagName="googleChart",createTag = true, namespace="http://alexscottrhodes.com/facelets", value="com.alexscottrhodes.googleChart")
public class GoogleChartTagHandler extends UIComponentBase{ 
	@Override
	 public String getFamily() { 
	  return "com.alexscottrhodes.googleChart"; 
	 }

	 @Override
	 public void encodeEnd(FacesContext context) throws IOException{ 
		 GoogleChartCore gcc = null;
		 ResponseWriter writer = context.getResponseWriter();
		 String output = null;
		 String id = "";
		 try{
			id = (String) this.getAttributes().get("id");
		 }catch(Exception e){
			try{throw new Exception("No ID Specified");}catch(Exception ex){e.printStackTrace();}
		 }
		 //Collect parameters
		 String typeString = (String) getAttributes().get("type");
		 Object chartObject = getAttributes().get("value");
		 
		 if(typeString == null){
			 try{
				 throw new ChartException("Invalid or missing chart type.");
			 }catch(Exception ex){
				 ex.printStackTrace();
			 }
		 }
		 
		 //Cast to appropriate chart model
		if(typeString.equals("combo")){
			 
			 try{
				 gcc = (GoogleChartCore) chartObject;
				 gcc.setId(id);
			 }catch(Exception e){
				 try{
					e.printStackTrace();	 
					 throw new ChartException("Invalid chart model.");
				 }catch(Exception ex){
					 ex.printStackTrace();
				 }
			 }
			 
			 
			 Builder b = new Builder();
			 try{
				 output = b.buildComboChart(gcc);
			 }catch(Exception e){
				 try{
					 e.printStackTrace();
					 throw e;}catch(Exception ex){}
			 }
		
		}
		 
		 else{
			 try{throw new ChartException("Invalid chart type:" + typeString);}catch(Exception e){}
		} 
		 writer.write(output);
	 }
	 

}
 