package com.alexscottrhodes.chartModel;

import java.util.ArrayList;
import java.util.HashMap;

import com.alexscottrhodes.constructionModel.ChartSeries;
import com.alexscottrhodes.enums.AxisType;

public class GoogleChartCore {
	private String id;
	private String title;
	private int width;
	private int height;
	private int indexLineVal;
	private String indexLineLabel;
	private ArrayList<ChartSeries> seriesList;
	private HashMap<AxisType, ArrayList<ChartSeries>> axes;
	private String titleColor;
	private boolean titleBold;
	private String verticalAxisLabel;
	
	public GoogleChartCore(){
		seriesList = new ArrayList<ChartSeries>();
		axes = new HashMap<AxisType, ArrayList<ChartSeries>>();
		axes.put(AxisType.X, new ArrayList<ChartSeries>());
		axes.put(AxisType.Y, new ArrayList<ChartSeries>());
	}
	
	public void addSeries(ChartSeries series){
		seriesList.add(series);
	}
	
	public void addAxisSeries(ChartSeries series, AxisType axis){
		axes.get(axis).add(series);
	}
	
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public String getTitle() {
		return title;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	public int getWidth() {
		return width;
	}
	public void setWidth(int width) {
		this.width = width;
	}
	public int getHeight() {
		return height;
	}
	public void setHeight(int height) {
		this.height = height;
	}
	public ArrayList<ChartSeries> getSeriesList() {
		return seriesList;
	}
	public void setSeriesList(ArrayList<ChartSeries> seriesList) {
		this.seriesList = seriesList;
	}

	public HashMap<AxisType, ArrayList<ChartSeries>> getAxes() {
		return axes;
	}

	public void setAxes(HashMap<AxisType, ArrayList<ChartSeries>> axes) {
		this.axes = axes;
	}

	public boolean isTitleBold() {
		return titleBold;
	}

	public void setTitleBold(boolean titleBold) {
		this.titleBold = titleBold;
	}

	public String getTitleColor() {
		return titleColor;
	}

	public void setTitleColor(String titleColor) {
		this.titleColor = titleColor;
	}

	public String getVerticalAxisLabel() {
		return verticalAxisLabel;
	}

	public void setVerticalAxisLabel(String verticalAxisLabel) {
		this.verticalAxisLabel = verticalAxisLabel;
	}

	public void setIndexLine(int value, String label) {
		this.indexLineVal = value;
		this.indexLineLabel = label;
	}

	public String getIndexLineLabel() {
		return indexLineLabel;
	}

	public int getIndexLineVal() {
		return indexLineVal;
	}

}
